package org.msh.tb.bd.tbforms.indicator.detailed;

import org.msh.tb.entities.Workspace;
import org.msh.tb.indicators.core.IndicatorFilters;

import javax.persistence.EntityManager;

public class TBForm10Block5ACasesQuery extends TBFormCasesQuery{

    public TBForm10Block5ACasesQuery(Workspace defaultWorkspace, IndicatorFilters indicatorFilters, String cellCondition, EntityManager entityManager) {
        super(defaultWorkspace, indicatorFilters, cellCondition, entityManager);
    }

    @Override
    protected String getJoinHQL() {
        return "join c.resHIV hiv";
    }

    protected String getSpecificConditions() {
        return "and c.classification = 0 and c.diagnosisType = 1 and c.age is not null and p.gender is not null "
                + " and hiv.id = ( "
                    + " select max (hiv2.id) "
                    + " from ExamHIV hiv2 "
                    + " where hiv2.tbcase.id = hiv.tbcase.id and hiv2.date = ( "
                    + " select max(hiv3.date) "
                    + " from ExamHIV hiv3 "
                    + " where hiv3.tbcase.id = hiv2.tbcase.id and (hiv3.date between :iniDate and :endDate ) ) )";
    }
}
